#!/bin/bash

VERSION=1.1

AUTHORIZED=false

# Application directories
DEFAULT_SITE_PATH="/Applications/Progressive Downloader.app"
DEFAULT_MAS_PATH="/Applications/PD.app"
DEFAULT_SITE_DATA_PATH="$HOME/Library/Application Support/Progressive Downloader Data"
CONTAINER_APP_PATH="$HOME/Library/Containers/com.PS.PSD"
CONTAINER_DOWNLOADER="$HOME/Library/Containers/com.PS.Downloader"
CONTAINER_HASH_CHECKER="$HOME/Library/Containers/com.PS.HashCheck"
CACHE_APP_PATH="$HOME/Library/Caches/com.PS.PSD"
CACHE_DOWNLOADER_PATH="$HOME/Library/Caches/com.PS.Downloader"
SCRIPTS_PATH="$HOME/Library/Application Scripts/com.PS.PSD"

WEB_EXTENSION_ID_FIREFOX="{9e355e1b-0f85-4ef3-9c07-bce9f96153bb}"
WEB_EXTENSION_ID_CHROME="ocpnplcljpgmejnfoadocihndccomoap"

function RemoveFolder
{
    rm -rf "$1" > /dev/null 2>&1

    if [ $? != 0 ]; then
        if [ "$AUTHORIZED" == false ]; then
            echo "Cannot remove '$1'! Please enter your password and try again."
        fi

        sudo echo "Authorized..."
        sudo rm -rf "$1"  > /dev/null 2>&1
        AUTHORIZED=true
    fi
}

function RemoveBundle
{
    echo "Removing Progressive Downloader installed at:"
    echo "$1"
    RemoveFolder "$1"
}

function RemoveNativeMessagingHostManifests
{
    find "$HOME/Library/Application Support" -name "com.ps.psd.json" -type f -print | while IFS= read -r f; do
        if grep -q "$WEB_EXTENSION_ID_FIREFOX" "$f"; then
            rm "$f"
        fi
    done
    find "$HOME/Library/Application Support" -name "com.ps.psd.json" -type f -print | while IFS= read -r f; do
        if grep -q "$WEB_EXTENSION_ID_CHROME" "$f"; then
            rm "$f"
        fi
    done
}

echo "Are you sure you want to completely remove Progressive Downloader from your Mac (y/N)? "
read ANSWER
if [ "$ANSWER" != "Y" ] && [ "$ANSWER" != "y" ] ; then
    exit 0
fi

# Kill application instances
killall "Progressive Downloader" > /dev/null 2>&1
killall "PD" > /dev/null 2>&1

# Remove app from custom folder
defaults read com.PS.PSD psAppPath > /dev/null 2>&1
if [ $? == 0 ]; then
    APPDIR=`defaults read com.PS.PSD psAppPath`
    APPDIR=`dirname "$APPDIR"`
    APPDIR=`dirname "$APPDIR"`
    APPDIR=`dirname "$APPDIR"`
    RemoveBundle "$APPDIR"
fi

# Remove the site verions of application from its default folder
if [ -d "$DEFAULT_SITE_PATH" ]; then
    RemoveBundle "$DEFAULT_SITE_PATH"
fi

# Remove the MAS version of application from its default folder
if [ -d "$DEFAULT_MAS_PATH" ]; then
    RemoveBundle "$DEFAULT_MAS_PATH"
fi

# Remove application data stored for the site version
if [ -d "$DEFAULT_SITE_DATA_PATH" ]; then
    RemoveFolder "$DEFAULT_SITE_DATA_PATH"
fi

# Remove the main application container
if [ -d "$CONTAINER_APP_PATH" ]; then
    RemoveFolder "$CONTAINER_APP_PATH"
fi

# Remove the downloader XPC service container
if [ -d "$CONTAINER_DOWNLOADER" ]; then
    RemoveFolder "$CONTAINER_DOWNLOADER"
fi

# Remove the hash checker XPC service container
if [ -d "$CONTAINER_HASH_CHECKER" ]; then
    RemoveFolder "$CONTAINER_HASH_CHECKER"
fi

# Remove temporary data of the main application
if [ -d "$CACHE_APP_PATH" ]; then
    RemoveFolder "$CACHE_APP_PATH"
fi

# Remove temporary data of the downloader XPC service
if [ -d "$CACHE_DOWNLOADER_PATH" ]; then
    RemoveFolder "$CACHE_DOWNLOADER_PATH"
fi

# Remove application scripts folder
if [ -d "$SCRIPTS_PATH" ]; then
    RemoveFolder "$SCRIPTS_PATH"
fi

# Remove Native Messaging Host manifests
RemoveNativeMessagingHostManifests

# Remove application preferences of the site and MAS versions
defaults delete com.PS.PSD > /dev/null 2>&1 # site
defaults delete com.PS.PSD > /dev/null 2>&1 # MAS

echo "Progressive Downloader has been removed from your Mac!"
echo "Don't forget to uninstall browser extensions"

